using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;
using System.Data.SqlClient;
using System.Runtime.Serialization;


namespace StrataFlix.Business
{
	[Serializable()]public partial class MovieCastBO : StrataFlixBaseBO
	{
		
		
		#region " Constructors "
		
		/// <summary>
		/// Initializes a new instance of the MovieCastBO class.
		/// </summary>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public MovieCastBO()
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the MovieCastBO class.
		/// </summary>
		/// <param name="Container">The IContainer to which this object will be added.</param>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public MovieCastBO(System.ComponentModel.IContainer Container)
		{
			//This call adds the component to the given container.
			Container.Add(this);
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the MovieCastBO class.
		/// </summary>
		/// <param name="info">The SerializationInfo for the object.</param>
		/// <param name="context">The StreamingContext for the source stream.</param>
		/// <remarks></remarks>
		protected MovieCastBO(SerializationInfo info, StreamingContext context) : base(info, context)
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Adds the necessary handlers for the MovieCastBO class.
		/// </summary>
		/// <remarks></remarks>
		private void AddHandlers()
		{
			this.CheckRulesOnCurrentRow += new MicroFour.StrataFrame.Business.BusinessLayer.CheckRulesOnCurrentRowEventHandler(MovieCastBO_CheckRulesOnCurrentRow);
			this.SetDefaultValues += new MicroFour.StrataFrame.Business.BusinessLayer.SetDefaultValuesEventHandler(MovieCastBO_SetDefaultValues);
		}
		
		#endregion
		
		#region " Event Handlers "
		
		/// <summary>
		/// Checks the business rules on the current row
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void MovieCastBO_CheckRulesOnCurrentRow(MicroFour.StrataFrame.Business.CheckRulesEventArgs e)
		{
			//-- Ensure that this is a unique entry
			if (! IsUniqueEntry())
			{
				this.AddBrokenRule(MovieCastBOFieldNames.mc_CastType, "Cast member and cast type combination already exists for movie.");
				this.AddBrokenRule(MovieCastBOFieldNames.mc_pl_pk, "Cast member and cast type combination already exists for movie.");
			}
		}
		
		/// <summary>
		/// Sets the default values for a new row
		/// </summary>
		/// <remarks></remarks>
		private void MovieCastBO_SetDefaultValues()
		{
			this.mc_CastType = MovieCastType.Actor;
			this.mc_CreatedAt = DateTime.Now;
			this.mc_CreatedBy = MicroFour.StrataFrame.Security.SecurityBasics.CurrentUser.UserPK;
		}
		
		#endregion
		
		#region " Private Methods "
		
		/// <summary>
		/// Verifies that the cast member entry is unique.  In this instance, both the server and business object will be checked
		/// since new records could have been added that the server doesn't know about and if another user has been entering
		/// data from another machine, there could be new records on the server that are not within this data set.  By
		/// checking both, we ensure that there are no duplicates.
		/// </summary>
		/// <returns></returns>
		/// <remarks></remarks>
		private bool IsUniqueEntry()
		{
			//-- Establish Locals
			SqlCommand cmd = new SqlCommand("SELECT COUNT(*) FROM MovieCast WHERE mc_mv_pk = @moviePk AND mc_pl_pk = @peoplePk AND mc_CastType = @castType AND mc_pk != @selfPk");
			bool r = true;
			
			//-- Create the parms
			cmd.Parameters.AddWithValue("@moviePk", mc_mv_pk).SqlDbType = SqlDbType.Int;
			cmd.Parameters.AddWithValue("@peoplePk", mc_pl_pk).SqlDbType = SqlDbType.Int;
			cmd.Parameters.AddWithValue("@castType", mc_CastType).SqlDbType = SqlDbType.Int;
			cmd.Parameters.AddWithValue("@selfPk", mc_pk).SqlDbType = SqlDbType.Int;
			
			//-- Set the results
			r = System.Convert.ToInt32(this.ExecuteScalar(cmd)) == 0;
			
			//-- If we still have a clean bill of health, check the BO for duplicated
			if (r)
			{
				//-- Just perform a select within the current data table to determine if entry is unique
				r = CurrentDataTable.Select("mc_mv_pk = " + mc_mv_pk.ToString() + " AND mc_pl_pk = " + mc_pl_pk.ToString() + " AND mc_CastType = " + System.Convert.ToInt32(mc_CastType).ToString() + " AND mc_pk <> " + mc_pk.ToString()).Length == 0;
				
			}
			
			//-- Return results
			return r;
		}
		
		#endregion
		
		#region " Protected Methods "
		
		/// <summary>
		/// Provide additional type descriptors
		/// </summary>
		/// <returns></returns>
		/// <remarks></remarks>
		protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
		{
			return new MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] {new ReflectionPropertyDescriptor("mc_CastMemberFullName", typeof(MovieCastBO))};
		}
		
		#endregion
		
		#region " Public Methods "
		
		
		
		#endregion
		
		#region " Public Properties "
		
		/// <summary>
		/// The cast members full name
		/// </summary>
		/// <value></value>
		/// <returns></returns>
		/// <remarks></remarks>
		[Browsable(false), BusinessFieldDisplayInEditor(), Description("Cast member full name"), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]public string mc_CastMemberFullName
		{
			get
			{
				//-- Establish Locals
				string r = "";
				
				//-- See if there is a last name
				if (System.Convert.ToString(this.CurrentRow["pl_LastName"]).Length > 0)
				{
					r = " " + System.Convert.ToString(this.CurrentRow["pl_LastName"]) + ", ";
				}
				
				//-- See if there is a first name
				if (System.Convert.ToString(this.CurrentRow["pl_FirstName"]).Length > 0)
				{
					r += System.Convert.ToString(this.CurrentRow["pl_FirstName"]);
				}
				
				//-- See if there is a middle name
				if (System.Convert.ToString(this.CurrentRow["pl_MiddleName"]).Length > 0)
				{
					r += " " + System.Convert.ToString(this.CurrentRow["pl_MiddleName"]);
				}
				
				//-- Return Results
				return r;
			}
		}
		
		#endregion
		
	}
	
}
